using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgConfirmQCSave
	/// </summary>
	public class DlgConfirmQCSave : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.GroupBox grpIcon;
		private System.Windows.Forms.PictureBox picWarning;
		private System.Windows.Forms.GroupBox grpComment;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.TextBox txtComment;
		private System.Windows.Forms.Label lblWarningMessage;
		private System.Windows.Forms.Label lblDetails;
		private System.Windows.Forms.Label dd;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbComment;
		private System.ComponentModel.IContainer components = null;
		private BOL.DailyControl _dailyControl;

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="dailyControl"></param>
		public DlgConfirmQCSave(ref BOL.DailyControl dailyControl)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			this._dailyControl = dailyControl;
			SetComponentProperties();
		}
		
		private void PopulateCombos()
		{
			this.cmbComment.Items.Clear();
			System.Data.DataTable dt = BOL.CannedComment.GetCannedComments("GC");
			foreach(DataRow drComment in dt.Rows)
			{
				this.cmbComment.Items.Add(drComment[Common.VbecsTables.CannedComment.CannedCommentText]);
			}
		}
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgConfirmQCSave));
			this.grpIcon = new System.Windows.Forms.GroupBox();
			this.picWarning = new System.Windows.Forms.PictureBox();
			this.grpComment = new System.Windows.Forms.GroupBox();
			this.cmbComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.dd = new System.Windows.Forms.Label();
			this.lblWarningMessage = new System.Windows.Forms.Label();
			this.txtComment = new System.Windows.Forms.TextBox();
			this.lblDetails = new System.Windows.Forms.Label();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpIcon.SuspendLayout();
			this.grpComment.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(336, 30);
			this.vbecsLogo1.TabIndex = 3;
			this.vbecsLogo1.Title = "Confirm Save";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 201);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// grpIcon
			// 
			this.grpIcon.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpIcon.Controls.Add(this.picWarning);
			this.grpIcon.Location = new System.Drawing.Point(4, 32);
			this.grpIcon.Name = "grpIcon";
			this.grpIcon.Size = new System.Drawing.Size(56, 152);
			this.grpIcon.TabIndex = 4;
			this.grpIcon.TabStop = false;
			// 
			// picWarning
			// 
			this.picWarning.Image = ((System.Drawing.Image)(resources.GetObject("picWarning.Image")));
			this.picWarning.Location = new System.Drawing.Point(4, 12);
			this.picWarning.Name = "picWarning";
			this.picWarning.Size = new System.Drawing.Size(45, 45);
			this.picWarning.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picWarning.TabIndex = 0;
			this.picWarning.TabStop = false;
			// 
			// grpComment
			// 
			this.grpComment.AccessibleDescription = "Enter a comment before saving the changes to the daily Q C configuration.";
			this.grpComment.AccessibleName = "Enter a comment before saving the changes to the daily Q C configuration.";
			this.grpComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpComment.Controls.Add(this.cmbComment);
			this.grpComment.Controls.Add(this.dd);
			this.grpComment.Controls.Add(this.lblWarningMessage);
			this.grpComment.Controls.Add(this.txtComment);
			this.grpComment.Controls.Add(this.lblDetails);
			this.grpComment.Location = new System.Drawing.Point(64, 32);
			this.grpComment.Name = "grpComment";
			this.grpComment.Size = new System.Drawing.Size(268, 152);
			this.grpComment.TabIndex = 0;
			this.grpComment.TabStop = false;
			// 
			// cmbComment
			// 
			this.cmbComment.AccessibleDescription = "Comment";
			this.cmbComment.AccessibleName = "Comment";
			this.cmbComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbComment.Interval = 100;
			this.cmbComment.Location = new System.Drawing.Point(68, 56);
			this.cmbComment.Name = "cmbComment";
			this.cmbComment.Size = new System.Drawing.Size(192, 22);
			this.cmbComment.TabIndex = 2;
			this.cmbComment.SelectedIndexChanged += new System.EventHandler(this.cmbComment_SelectedIndexChanged);
			// 
			// dd
			// 
			this.dd.Location = new System.Drawing.Point(8, 56);
			this.dd.Name = "dd";
			this.dd.Size = new System.Drawing.Size(60, 20);
			this.dd.TabIndex = 1;
			this.dd.Text = "Comment*";
			this.dd.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblWarningMessage
			// 
			this.lblWarningMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblWarningMessage.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblWarningMessage.Location = new System.Drawing.Point(8, 12);
			this.lblWarningMessage.Name = "lblWarningMessage";
			this.lblWarningMessage.Size = new System.Drawing.Size(252, 32);
			this.lblWarningMessage.TabIndex = 0;
			this.lblWarningMessage.Text = "Enter a comment before saving the changes to the daily QC configuration.";
			this.lblWarningMessage.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// txtComment
			// 
			this.txtComment.AcceptsReturn = true;
			this.txtComment.AccessibleDescription = "Details";
			this.txtComment.AccessibleName = "Details";
			this.txtComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtComment.Location = new System.Drawing.Point(68, 84);
			this.txtComment.MaxLength = 255;
			this.txtComment.Multiline = true;
			this.txtComment.Name = "txtComment";
			this.txtComment.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.txtComment.Size = new System.Drawing.Size(192, 60);
			this.txtComment.TabIndex = 4;
			this.txtComment.Text = "";
			this.txtComment.TextChanged += new System.EventHandler(this.txtComment_TextChanged);
			// 
			// lblDetails
			// 
			this.lblDetails.Location = new System.Drawing.Point(8, 84);
			this.lblDetails.Name = "lblDetails";
			this.lblDetails.Size = new System.Drawing.Size(60, 20);
			this.lblDetails.TabIndex = 3;
			this.lblDetails.Text = "Details";
			this.lblDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(176, 188);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 1;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(256, 188);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// DlgConfirmQCSave
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(336, 217);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpComment);
			this.Controls.Add(this.grpIcon);
			this.hlphelpChm.SetHelpKeyword(this, "Configure_Daily_QC.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(344, 244);
			this.Name = "DlgConfirmQCSave";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "VBECS - Confirm Save";
			this.Load += new System.EventHandler(this.DlgConfirmQCSave_Load);
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgConfirmQCSave_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpIcon, 0);
			this.Controls.SetChildIndex(this.grpComment, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.grpIcon.ResumeLayout(false);
			this.grpComment.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = "Confirm Save";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC051.DlgConfirmQCSave());
			//
			this.cmbComment.Interval = 100;
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgConfirmQCSave_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			if ( !this.btnOK.EnabledButton )
			{
				textToSpeak = this.btnOK.GetToolTip();
			}
			//
			this.SpeakMessage( textToSpeak );
		}

		private void cmbComment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this._dailyControl.Comments = cmbComment.SelectedItem.ToString() + this.txtComment.Text;
			if(cmbComment.SelectedItem.ToString().ToUpper() != "OTHER")
			{
				if(cmbComment.SelectedItem.ToString().Length > 0)
				{
					this.btnOK.SetToolTip("");
					this.btnOK.EnabledButton = this._dailyControl.Comments.Length > 0;
				}
			}
			
		}

		private void txtComment_TextChanged(object sender, System.EventArgs e)
		{
			if(cmbComment.SelectedItem != null)
			{
				if(cmbComment.SelectedItem.ToString().Length > 0)
				{
					if(txtComment.Text.Length > 0)
					{
						this._dailyControl.Comments = cmbComment.SelectedItem.ToString() + this.txtComment.Text;
						this.btnOK.SetToolTip("");
						this.btnOK.EnabledButton = this._dailyControl.Comments.Length > 0;
					}
				}
			}
		}

		private void DlgConfirmQCSave_Load(object sender, System.EventArgs e)
		{
			this.PopulateCombos();
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.CommentRequired().ResString);
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = System.Windows.Forms.DialogResult.Cancel;
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.Close();
		}
	}
}

